import{h}from"@stencil/core";import{addQueryArgs,getQueryArgs}from"@wordpress/url";import{__,sprintf}from"@wordpress/i18n";import{speak}from"@wordpress/a11y";import apiFetch,{handleNonceError}from"../../../../functions/fetch";import"@store/product/facebook";import"@store/product/google";export class ScProductItemList{constructor(){this.ids=void 0,this.sort="created_at:desc",this.query=void 0,this.searchEnabled=!0,this.sortEnabled=!0,this.collectionEnabled=!0,this.collectionId=void 0,this.pageTitle=void 0,this.featured=!1,this.paginationEnabled=!0,this.ajaxPagination=!0,this.paginationAutoScroll=!0,this.layoutConfig=void 0,this.paginationAlignment="center",this.limit=15,this.page=1,this.products=void 0,this.loading=!1,this.busy=!1,this.error=void 0,this.currentPage=1,this.currentQuery=void 0,this.pagination={total:0,total_pages:0},this.collections=void 0,this.selectedCollections=[]}handleProductsChanged(e,t){var r;const i=new Set([...(t||[]).map((e=>e.id)),...(e||[]).map((e=>e.id))]);if((null==e?void 0:e.length)===(null==t?void 0:t.length)&&i.size===e.length)return;const s=[this.pageTitle,this.paginationEnabled?sprintf(__("Page %d","surecart"),this.currentPage):void 0,this.sort?this.renderSortName():void 0,this.query||(null===(r=this.selectedCollections)||void 0===r?void 0:r.length)?__("Search results","surecart"):void 0].filter((e=>!!e)).join(" - ");this.scProductsViewed.emit({products:this.products,pageTitle:s,collectionId:this.collectionId})}componentWillLoad(){var e;(null===(e=null==this?void 0:this.products)||void 0===e?void 0:e.length)?this.handleProductsChanged(this.products):this.getProducts(),this.collectionEnabled&&this.getCollections()}doPagination(e){if(this.ajaxPagination)return this.page=e,this.updateProducts(),void(this.paginationAutoScroll&&this.el.scrollIntoView({behavior:"smooth"}));const t=addQueryArgs(location.href,{"product-page":e});window.location.replace(t)}async getProducts(){const{"product-page":e}=getQueryArgs(window.location.href);this.page=this.paginationEnabled&&e?parseInt(e):1;try{this.loading=!0,await this.fetchProducts()}catch(e){console.error(e)}finally{this.loading=!1}}async getCollections(){try{this.collections=await apiFetch({path:addQueryArgs("surecart/v1/product_collections/",{per_page:100})})}catch(e){console.error(e)}}async handleSortChange(){this.page=1,this.updateProducts()}async updateProducts(e=!1){var t;try{this.busy=!0,await this.fetchProducts(),this.query&&e&&this.scSearched.emit({searchString:this.query,searchResultCount:null===(t=this.products)||void 0===t?void 0:t.length,searchResultIds:this.products.map((e=>e.id))})}catch(e){console.log("error"),console.error(e),this.error=e.message||__("An unknown error occurred.","surecart")}finally{this.busy=!1}}handleIdsChange(){null!==this.debounce&&(clearTimeout(this.debounce),this.debounce=null),this.debounce=window.setTimeout((()=>{this.updateProducts(),this.debounce=null}),200)}async fetchProducts(){var e,t;let r=(null===(e=this.selectedCollections)||void 0===e?void 0:e.map((e=>e.id)))||[];this.collectionId&&(r=[this.collectionId]);try{const e=await apiFetch({path:addQueryArgs("surecart/v1/products/",{expand:["prices","featured_product_media","product_medias","product_media.media","variants"],archived:!1,status:["published"],per_page:this.limit,page:this.page,sort:this.sort,product_collection_ids:r,...this.featured?{featured:!0}:{},...(null===(t=this.ids)||void 0===t?void 0:t.length)?{ids:this.ids}:{},...this.query?{query:this.query}:{}}),parse:!1});this.currentQuery=this.query,this.pagination={total:parseInt(e.headers.get("X-WP-Total")),total_pages:parseInt(e.headers.get("X-WP-TotalPages"))},this.products=await e.json(),(r.length||this.query)&&speak(sprintf(__("%s products found","surecart"),this.pagination.total))}catch(e){await handleNonceError(e).then((()=>this.fetchProducts())).catch((e=>{this.error=e.message||__("An unknown error occurred.","surecart")}))}}renderSortName(){switch(this.sort){case"created_at:desc":return __("Latest","surecart");case"created_at:asc":return __("Oldest","surecart");case"name:asc":return __("Alphabetical, A-Z","surecart");case"name:desc":return __("Alphabetical, Z-A","surecart");default:return __("Sort","surecart")}}toggleSelectCollection(e){this.selectedCollections.find((t=>t.id===e.id))?this.selectedCollections=this.selectedCollections.filter((t=>t.id!==e.id)):this.selectedCollections=[...this.selectedCollections,e]}getCollectionsAfterFiltered(){var e;return(null!==(e=this.collections)&&void 0!==e?e:[]).filter((e=>!this.selectedCollections.some((t=>t.id===e.id))))}isPaginationAvailable(){var e;return!!(null===(e=this.products)||void 0===e?void 0:e.length)&&this.pagination.total>this.products.length&&this.paginationEnabled}render(){var e,t,r,i,s,o;return h("div",{class:{"product-item-list__wrapper":!0,"product-item-list__has-search":!!this.query}},this.error&&h("sc-alert",{type:"danger",open:!0},this.error),(this.searchEnabled||this.sortEnabled||this.collectionEnabled)&&h("div",{class:"product-item-list__header"},h("div",{class:"product-item-list__controls"},h("div",{class:"product-item-list__sort"},this.sortEnabled&&h("sc-dropdown",{style:{"--panel-width":"15em"}},h("sc-button",{type:"text",caret:!0,slot:"trigger"},h("sc-visually-hidden",null,__("Dropdown to sort products.","surecart")," "),this.renderSortName(),h("sc-visually-hidden",null," ",__("selected.","surecart"))),h("sc-menu",{"aria-label":__("Sort Products","surecart")},h("sc-menu-item",{"aria-label":__("Sort by latest","surecart"),onClick:()=>this.sort="created_at:desc"},__("Latest","surecart")),h("sc-menu-item",{"aria-label":__("Sort by oldest","surecart"),onClick:()=>this.sort="created_at:asc"},__("Oldest","surecart")),h("sc-menu-item",{"aria-label":__("Sort by name, A to Z","surecart"),onClick:()=>this.sort="name:asc"},__("Alphabetical, A-Z","surecart")),h("sc-menu-item",{"aria-label":__("Sort by name, Z to A","surecart"),onClick:()=>this.sort="name:desc"},__("Alphabetical, Z-A","surecart")))),this.collectionEnabled&&(null!==(e=this.collections)&&void 0!==e?e:[]).length>0&&h("sc-dropdown",{style:{"--panel-width":"15rem"}},h("sc-button",{type:"text",caret:!0,slot:"trigger"},h("sc-visually-hidden",null,sprintf(__("Dropdown to filter products by collection. %s selected.","surecart"),(null===(t=this.selectedCollections)||void 0===t?void 0:t.length)?this.selectedCollections.map((e=>null==e?void 0:e.name)).join(","):__("None","surecart"))),h("span",{"aria-hidden":!0}," ",__("Filter","surecart"))),h("sc-menu",{"aria-label":__("Filter products","surecart")},(null!==(r=this.collections)&&void 0!==r?r:[]).map((e=>h("sc-menu-item",{checked:this.selectedCollections.some((t=>(null==t?void 0:t.id)===(null==e?void 0:e.id))),onClick:()=>this.toggleSelectCollection(e),key:null==e?void 0:e.id,"aria-label":sprintf(__("Filter by %s","surecart"),null==e?void 0:e.name)},e.name)))))),h("div",{class:"product-item-list__search"},this.searchEnabled&&((null===(i=this.query)||void 0===i?void 0:i.length)&&this.query===this.currentQuery?h("div",{class:"product-item-list__search-tag"},h("div",{class:"product-item-list__search-label"},__("Search Results:","surecart")),h("sc-tag",{clearable:!0,onScClear:()=>{this.query="",this.currentQuery="",this.updateProducts()},"aria-label":sprintf(__("Searched for %s. Press space to clear search.","surecart"),this.query)},this.query)):h("sc-input",{type:"text",placeholder:__("Search","surecart"),size:"small",onKeyUp:e=>{"Enter"===e.key&&(this.query=e.target.value,this.updateProducts(!0))},value:this.query,clearable:!0},this.query?h("sc-icon",{class:"clear-button",slot:"prefix",name:"x",onClick:()=>{this.query=""}}):h("sc-icon",{slot:"prefix",name:"search"}),h("sc-button",{class:"search-button",type:"link",slot:"suffix",busy:this.busy,onClick:()=>{this.updateProducts(!0)}},__("Search","surecart")))))),this.collectionEnabled&&this.selectedCollections.length>0&&h("div",{class:"product-item-list__search-tag"},this.selectedCollections.map((e=>h("sc-tag",{key:null==e?void 0:e.id,clearable:!0,onScClear:()=>{this.toggleSelectCollection(e)}},null==e?void 0:e.name))))),!(null===(s=this.products)||void 0===s?void 0:s.length)&&!this.loading&&h("sc-empty",{class:"product-item-list__empty",icon:"shopping-bag"},__("No products found.","surecart")),h("section",{class:"product-item-list","aria-label":__("Product list","surecart")},this.loading?[...Array((null===(o=this.products)||void 0===o?void 0:o.length)||this.limit||10)].map(((e,t)=>h("div",{class:"product-item-list__loader",key:t},(this.layoutConfig||[]).map((e=>{var t,r;switch(e.blockName){case"surecart/product-item-title":return h("div",{style:{textAlign:"var(--sc-product-title-align)"}},h("sc-skeleton",{style:{width:"80%",display:"inline-block"}}));case"surecart/product-item-image":return h("sc-skeleton",{style:{width:"100%",minHeight:"90%",aspectRatio:null!==(r=null===(t=e.attributes)||void 0===t?void 0:t.ratio)&&void 0!==r?r:"1/1.4","--sc-border-radius-pill":"12px",display:"inline-block"}});case"surecart/product-item-price":return h("div",{style:{textAlign:"var(--sc-product-price-align)"}},h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}));default:return null}}))))):(this.products||[]).map(((e,t)=>h("sc-product-item",{key:null==e?void 0:e.id,...this.products.length-1===t?{"aria-label":sprintf(__("You have reached the end of product list. %s","surecart"),this.isPaginationAvailable()?__("Press tab to browse more products using pagination.","surecart"):__("No more products to browse.","surecart"))}:{},exportparts:"title, price, image",product:e,layoutConfig:this.layoutConfig})))),this.isPaginationAvailable()&&h("div",{class:{"product-item-list__pagination":!0,"--is-aligned-left":"left"===this.paginationAlignment,"--is-aligned-center":"center"===this.paginationAlignment,"--is-aligned-right":"right"===this.paginationAlignment}},h("sc-pagination",{page:this.page,perPage:this.limit,total:this.pagination.total,totalPages:this.pagination.total_pages,totalShowing:this.limit,onScNextPage:()=>this.doPagination(this.page+1),onScPrevPage:()=>this.doPagination(this.page-1)})),(this.busy||this.loading)&&h("sc-block-ui",null))}static get is(){return"sc-product-item-list"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-product-item-list.scss"]}}static get styleUrls(){return{$:["sc-product-item-list.css"]}}static get properties(){return{ids:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Limit to a set of ids."}},sort:{type:"string",mutable:!0,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Sort"},attribute:"sort",reflect:!1,defaultValue:"'created_at:desc'"},query:{type:"string",mutable:!0,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Query to search for"},attribute:"query",reflect:!1},searchEnabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should allow search"},attribute:"search-enabled",reflect:!1,defaultValue:"true"},sortEnabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should allow search"},attribute:"sort-enabled",reflect:!1,defaultValue:"true"},collectionEnabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should allow collection filter"},attribute:"collection-enabled",reflect:!1,defaultValue:"true"},collectionId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Show for a specific collection"},attribute:"collection-id",reflect:!1},pageTitle:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The page title"},attribute:"page-title",reflect:!1},featured:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Show only featured products."},attribute:"featured",reflect:!1,defaultValue:"false"},paginationEnabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should we paginate?"},attribute:"pagination-enabled",reflect:!1,defaultValue:"true"},ajaxPagination:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should we paginate?"},attribute:"ajax-pagination",reflect:!1,defaultValue:"true"},paginationAutoScroll:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Should we auto-scroll to the top when paginating via ajax"},attribute:"pagination-auto-scroll",reflect:!1,defaultValue:"true"},layoutConfig:{type:"unknown",mutable:!1,complexType:{original:"LayoutConfig",resolved:"{ blockName: string; attributes: any; }[]",references:{LayoutConfig:{location:"local",path:"/home/runner/work/surecart-wp/surecart-wp/packages/components/src/components/controllers/products/sc-product-item-list/sc-product-item-list.tsx"}}},required:!1,optional:!1,docs:{tags:[],text:""}},paginationAlignment:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"pagination-alignment",reflect:!1,defaultValue:"'center'"},limit:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"limit",reflect:!1,defaultValue:"15"},page:{type:"number",mutable:!0,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"page",reflect:!1,defaultValue:"1"},products:{type:"unknown",mutable:!0,complexType:{original:"Product[]",resolved:"Product[]",references:{Product:{location:"import",path:"../../../../types"}}},required:!1,optional:!0,docs:{tags:[],text:""}},pagination:{type:"unknown",mutable:!0,complexType:{original:"{\n    total: number;\n    total_pages: number;\n  }",resolved:"{ total: number; total_pages: number; }",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Pagination"},defaultValue:"{\n    total: 0,\n    total_pages: 0,\n  }"}}}static get states(){return{loading:{},busy:{},error:{},currentPage:{},currentQuery:{},collections:{},selectedCollections:{}}}static get events(){return[{method:"scSearched",name:"scSearched",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Product was searched"},complexType:{original:"ProductsSearchedParams",resolved:"ProductsSearchedParams",references:{ProductsSearchedParams:{location:"import",path:"../../../../types"}}}},{method:"scProductsViewed",name:"scProductsViewed",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Products viewed"},complexType:{original:"ProductsViewedParams",resolved:"ProductsViewedParams",references:{ProductsViewedParams:{location:"import",path:"../../../../types"}}}}]}static get elementRef(){return"el"}static get watchers(){return[{propName:"products",methodName:"handleProductsChanged"},{propName:"sort",methodName:"handleSortChange"},{propName:"selectedCollections",methodName:"handleSortChange"},{propName:"query",methodName:"handleSortChange"},{propName:"ids",methodName:"handleIdsChange"},{propName:"limit",methodName:"handleIdsChange"},{propName:"featured",methodName:"handleIdsChange"}]}}