import{h,Fragment}from"@stencil/core";import{__,sprintf}from"@wordpress/i18n";import{speak}from"@wordpress/a11y";import{zones}from"../../../functions/tax";export class ScTaxIdInput{constructor(){this.country=void 0,this.show=!1,this.type="other",this.number=null,this.status="unknown",this.loading=void 0,this.help=void 0,this.otherLabel=__("Tax ID","surecart"),this.caGstLabel=__("GST Number","surecart"),this.auAbnLabel=__("ABN Number","surecart"),this.gbVatLabel=__("UK VAT","surecart"),this.euVatLabel=__("EU VAT","surecart"),this.taxIdTypes=[],this.required=!1}async reportValidity(){return this.input.reportValidity()}onLabelChange(){zones.ca_gst.label=this.caGstLabel||zones.ca_gst.label,zones.au_abn.label=this.auAbnLabel||zones.au_abn.label,zones.gb_vat.label=this.gbVatLabel||zones.gb_vat.label,zones.eu_vat.label=this.euVatLabel||zones.eu_vat.label,zones.other.label=this.otherLabel||zones.other.label}componentWillLoad(){this.onLabelChange()}renderStatus(){return"valid"===this.status?h("sc-icon",{name:"check",slot:"prefix",style:{color:"var(--sc-color-success-500)"}}):"invalid"===this.status?h("sc-icon",{name:"x",slot:"prefix",style:{color:"var(--sc-color-danger-500)"}}):void 0}filteredZones(){return this.taxIdTypes.length?Object.keys(zones).filter((e=>this.taxIdTypes.includes(e))).reduce(((e,t)=>(e[t]=zones[t],e)),{}):zones}onTaxIdTypesChange(){this.taxIdTypes.length&&(this.type=this.taxIdTypes.includes("other")?"other":this.taxIdTypes[0])}getZoneLabel(){var e,t;const r=this.filteredZones()||{};return(null===(e=null==r?void 0:r[(null==this?void 0:this.type)||"other"])||void 0===e?void 0:e.label)||(null===(t=null==r?void 0:r[Object.keys(r)[0]])||void 0===t?void 0:t.label)}render(){var e,t,r,a,s;return h(Fragment,null,h("sc-input",{name:"tax_identifier.number_type",required:this.required,value:this.type,style:{display:"none"}}),h("sc-input",{ref:e=>this.input=e,label:this.getZoneLabel(),"aria-label":__("Tax ID","surecart"),placeholder:__("Enter Tax ID","surecart"),name:"tax_identifier.number",value:this.number,onScInput:e=>{e.stopImmediatePropagation(),this.scInput.emit({number:e.target.value,number_type:this.type||"other"})},onScChange:e=>{e.stopImmediatePropagation(),this.scChange.emit({number:e.target.value,number_type:this.type||"other"})},help:this.help,required:this.required},this.loading&&"eu_vat"===this.type?h("sc-spinner",{slot:"prefix",style:{"--spinner-size":"10px"}}):this.renderStatus(),1===(null===(e=Object.keys(this.filteredZones()||{}))||void 0===e?void 0:e.length)?h("span",{slot:"suffix"},null===(r=null===(t=Object.values(this.filteredZones()||{}))||void 0===t?void 0:t[0])||void 0===r?void 0:r.label_small):h("sc-dropdown",{slot:"suffix",position:"bottom-right",role:"select","aria-multiselectable":"false","aria-label":__("Select number type","surecart")},h("sc-button",{type:"text",slot:"trigger",caret:!0,loading:!1,style:{color:"var(--sc-input-label-color)"},tabindex:"0"},null===(s=null===(a=this.filteredZones())||void 0===a?void 0:a[(null==this?void 0:this.type)||"other"])||void 0===s?void 0:s.label_small),h("sc-menu",null,Object.keys(this.filteredZones()||{}).map((e=>h("sc-menu-item",{role:"option",onClick:()=>{this.scInput.emit({number:this.number,number_type:e}),this.scChange.emit({number:this.number,number_type:e}),this.type=e},onKeyDown:t=>{var r;"Enter"===t.key&&(this.scInput.emit({number:this.number,number_type:e}),this.scChange.emit({number:this.number,number_type:e}),this.type=e,null===(r=this.input)||void 0===r||r.triggerFocus(),speak(sprintf(__("%s selected","surecart"),zones[e].label_small,"assertive")))},checked:this.type===e,"aria-selected":this.type===e?"true":"false","aria-label":zones[e].label_small},zones[e].label_small)))))))}static get is(){return"sc-tax-id-input"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-tax-id-input.css"]}}static get styleUrls(){return{$:["sc-tax-id-input.css"]}}static get properties(){return{country:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The country code."},attribute:"country",reflect:!1},show:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Force show the field."},attribute:"show",reflect:!1,defaultValue:"false"},type:{type:"string",mutable:!0,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Type of tax id"},attribute:"type",reflect:!1,defaultValue:"'other'"},number:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Tax ID Number"},attribute:"number",reflect:!1,defaultValue:"null"},status:{type:"string",mutable:!1,complexType:{original:"'valid' | 'invalid' | 'unknown'",resolved:'"invalid" | "unknown" | "valid"',references:{}},required:!1,optional:!1,docs:{tags:[],text:"The status"},attribute:"status",reflect:!1,defaultValue:"'unknown'"},loading:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Is this loading?"},attribute:"loading",reflect:!1},help:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Help text."},attribute:"help",reflect:!1},otherLabel:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Other zones label"},attribute:"other-label",reflect:!1,defaultValue:"__('Tax ID', 'surecart')"},caGstLabel:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"GST zone label"},attribute:"ca-gst-label",reflect:!1,defaultValue:"__('GST Number', 'surecart')"},auAbnLabel:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"AU zone label"},attribute:"au-abn-label",reflect:!1,defaultValue:"__('ABN Number', 'surecart')"},gbVatLabel:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"UK zone label"},attribute:"gb-vat-label",reflect:!1,defaultValue:"__('UK VAT', 'surecart')"},euVatLabel:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"EU zone label"},attribute:"eu-vat-label",reflect:!1,defaultValue:"__('EU VAT', 'surecart')"},taxIdTypes:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Tax ID Types which will be shown"},defaultValue:"[]"},required:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether tax input is required"},attribute:"required",reflect:!0,defaultValue:"false"}}}static get events(){return[{method:"scChange",name:"scChange",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Make a request to update the order."},complexType:{original:"{ number: string; number_type: string }",resolved:"{ number: string; number_type: string; }",references:{}}},{method:"scInput",name:"scInput",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Make a request to update the order."},complexType:{original:"Partial<{ number: string; number_type: string }>",resolved:"{ number?: string; number_type?: string; }",references:{Partial:{location:"global"}}}},{method:"scInputType",name:"scInputType",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Change the Type"},complexType:{original:"string",resolved:"string",references:{}}},{method:"scSetState",name:"scSetState",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Set the checkout state."},complexType:{original:"string",resolved:"string",references:{}}}]}static get methods(){return{reportValidity:{complexType:{signature:"() => Promise<boolean>",parameters:[],references:{Promise:{location:"global"}},return:"Promise<boolean>"},docs:{text:"",tags:[]}}}}static get watchers(){return[{propName:"otherLabel",methodName:"onLabelChange"},{propName:"caGstLabel",methodName:"onLabelChange"},{propName:"auAbnLabel",methodName:"onLabelChange"},{propName:"gbVatLabel",methodName:"onLabelChange"},{propName:"euVatLabel",methodName:"onLabelChange"},{propName:"taxIdTypes",methodName:"onTaxIdTypesChange"}]}}